<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($tournament) ? 'Editar Torneo' : 'Crear Torneo' ?></title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>

<body>
    <div class="head">
        <div class="tittle">Crear Torneo</div>
        <a href="../public/index.php">
            <div class="pic img iClose"></div>
        </a>
    </div>
    <div class="wb">
        <form action="../public/tournament.php?action=<?= isset($tournament) ? 'update' : 'store' ?>" method="POST" class="form" id="tournamentForm">
            <?php if (isset($tournament)): ?>
                <input type="hidden" name="id" value="<?= htmlspecialchars($tournament['id']) ?>">
            <?php endif; ?>

            <div class="formItem">
                <input type="text" class="formInput" id="name" placeholder="Nombre" required autocomplete="off" name="name" value="<?= htmlspecialchars($tournament['name'] ?? '') ?>">
                <label for="name" class="formLabel">Nombre</label>
            </div>

            <div class="formItem">
                <textarea class="formInput" id="desc" placeholder="Descripción" required autocomplete="off" name="description"><?= htmlspecialchars($tournament['description'] ?? '') ?></textarea>
                <label for="desc" class="formLabel">Descripción</label>
            </div>

            <div class="formItem">
                <label for="date" class="formLabel">Fecha</label>
                <input type="date" class="formInput" id="date" required autocomplete="off" name="date" value="<?= htmlspecialchars($tournament['date'] ?? '') ?>">
            </div>

            <button class="button-85" role="button" type="submit">Guardar</button>
        </form>
    </div>
</body>

</html>