<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title><?= isset($team) ? 'Editar Pareja' : 'Crear Pareja' ?></title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>

<body>
    <div class="head">
        <div class="tittle"><?= $team['desc'] ?? 'Crear Pareja' ?></div>
        <a href="../public/tournament.php?id=<?= $_GET['tournament'] ?>#teams">
            <div class="pic iClose"></div>
        </a>
    </div>
    <div class="scroll-container">
        <form action="../public/team.php?action=<?= isset($team) ? 'update' : 'store' ?>" method="POST" class="form">
            <div class="formItem">
                <label for="team1">Jugador 1:</label>
                <input list="team1-list" name="p1" id="p1" class="formInput" required value="<?= $team['p1']['id'] ?? '' ?>">
                <datalist id="team1-list">
                    <?php foreach ($players as $player): ?>
                        <option value="<?= htmlspecialchars($player['id']) ?>">
                            <?= htmlspecialchars($player['pNombre'] . " " . $player['pApellido']) ?>
                        </option>
                    <?php endforeach; ?>
                </datalist>
            </div>

            <div class="formItem">
                <label for="team2">Jugador 2:</label>
                <input list="team2-list" name="p2" id="p2" class="formInput" required value="<?= $team['p2']['id'] ?? '' ?>">
                <datalist id="team2-list">
                    <?php foreach ($players as $player): ?>
                        <option value="<?= htmlspecialchars($player['id']) ?>">
                            <?= htmlspecialchars($player['pNombre'] . " " . $player['pApellido']) ?>
                        </option>
                    <?php endforeach; ?>
                </datalist>
            </div>
            <div class="formItem">
                <select name="group" id="group" class="formSelect" autocomplete="off">
                    <option value="" <?= isset($team['group']) && $team['group'] === '' ? 'selected' : '' ?>>Sin Grupo</option>
                    <option value="1" <?= isset($team['group']) && $team['group'] == '1' ? 'selected' : '' ?>>1</option>
                    <option value="2" <?= isset($team['group']) && $team['group'] == '2' ? 'selected' : '' ?>>2</option>
                    <option value="3" <?= isset($team['group']) && $team['group'] == '3' ? 'selected' : '' ?>>3</option>
                    <option value="4" <?= isset($team['group']) && $team['group'] == '4' ? 'selected' : '' ?>>4</option>
                    <option value="5" <?= isset($team['group']) && $team['group'] == '5' ? 'selected' : '' ?>>5</option>
                </select>
            </div>
            <input type="hidden" name="tournament" value="<?= $_GET['tournament'] ?>" />
            <?php if (isset($team)): ?>
                <input type="hidden" name="id" value="<?= htmlspecialchars($team['id']) ?>" />
            <?php endif; ?>
            <button class="button-85" role="button" value="Submit" type="submit">Guardar</button>
        </form>
    </div>
    <a href="../public/index.php">Volver</a>
</body>

</html>