<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

require '../controllers/GameController.php';
require '../controllers/TeamController.php';
require '../views/layouts/navbar.php';

$controller = new GameController();
$teamController = new TeamController();

$action = $_GET['action'] ?? null;
$id = $_GET['id'] ?? null;
$tournament = $_GET['tournament'] ?? null;

switch ($action) {
    case 'create':
        $teamController->create($tournament);
        break;
    case 'store':
        $teamController->store();
        break;
    case 'edit':
        $teamController->show($id, $tournament);
        break;
    case 'update':
        $teamController->update();
        break;
    default:
        $teamController->show($id, $tournament);
        break;
}
