<?php
require_once '../../../4p1c_4cc45t0db._.php';
require_once '../utils/helpers.php';
require_once '../models/Player.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);
class PlayerController
{
    private $playerModel;

    public function __construct()
    {
        $db = Database::connect();
        $this->playerModel = new Player($db);
    }

    public function index()
    {
        $players = $this->playerModel->getAllPlayers();
        require '../views/player_list.php';
    }

    public function show($id)
    {
        $player = null;
        if ($id) {
            $player = $this->playerModel->getPlayerById($id);
        }

        require '../views/player_form.php';
    }

    // Método para almacenar un nuevo jugador
    public function store()
    {
        $data = $_POST;
        $data['code'] = generateUUID();
        $response = $this->playerModel->createPlayer($data);
        $player = $this->playerModel->getPlayerIdByCode($data['code']);
        header('Location: ../public/player.php?action=edit&id='.$player);
    }

    public function update()
    {
        if (isset($_POST['id'])) {
            $data = $_POST;
            $this->playerModel->updatePlayer($data);
            header('Location: ../public/player.php?action=edit&id=' . $_POST['id']);
        } else {
            echo "Error: No se proporcionó un ID válido para actualizar el jugador.";
        }
    }
}
