<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

require_once '../../../4p1c_4cc45t0db._.php';
require_once '../models/Player.php';

class ImageUploadController
{
    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_FILES['image']['tmp_name']) && isset($_POST['id'])) {
                $playerId = $_POST['id'];
                $fileTmpPath = $_FILES['image']['tmp_name'];
                $webpFilePath = '../../app/public/img/user/player_';

                // Crear instancia de modelo
                $db = Database::connect();
                $playerModel = new Player($db);

                // Obtener la imagen anterior
                $oldImage = $playerModel->getPlayerPicById($playerId);
                
                // Si el jugador tiene imagen, usa su uniqid
                if ($oldImage) {
                    $imgid = $oldImage; // Mantener el mismo uniqid
                    $webpFilePath .= $imgid . '.webp';
                } else {
                    $imgid = uniqid(); // Generar un nuevo uniqid
                    $webpFilePath .= $imgid . '.webp';
                }

                // Convierte la imagen a WebP
                if ($this->convertImageToWebP($fileTmpPath, $webpFilePath)) {
                    // Actualiza la imagen en la base de datos solo si no hay imagen previa
                    if (!$oldImage) {
                        if ($playerModel->updatePlayerPic($playerId, $imgid)) {
                            echo json_encode(['success' => true, 'path' => $webpFilePath]);
                        } else {
                            echo json_encode(['success' => false, 'message' => 'Error al actualizar la imagen del jugador']);
                        }
                    } else {
                        echo json_encode(['success' => true, 'path' => $webpFilePath]); // Sin actualización en DB
                    }
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al convertir la imagen a WebP']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'No se recibió la imagen o el ID']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Método no permitido']);
        }
    }

    private function convertImageToWebP($filePath, $outputPath, $newWidth = 300, $newHeight = 300)
    {
        // Lee el contenido del archivo
        $imageData = file_get_contents($filePath);
        if ($imageData === false) {
            return false;
        }

        $sourceImage = imagecreatefromstring($imageData);
        if ($sourceImage === false) {
            return false;
        }

        $origWidth = imagesx($sourceImage);
        $origHeight = imagesy($sourceImage);
        $cropSize = min($origWidth, $origHeight);

        // Calcula los puntos de recorte centrados
        $cropX = ($origWidth - $cropSize) / 2;
        $cropY = ($origHeight - $cropSize) / 2;

        $croppedImage = imagecreatetruecolor($newWidth, $newHeight);
        imagecopyresampled(
            $croppedImage,
            $sourceImage,
            0,
            0,
            round($cropX),
            round($cropY),
            round($newWidth),
            round($newHeight),
            round($cropSize),
            round($cropSize)
        );

        // Guarda la imagen en formato WebP
        if (imagewebp($croppedImage, $outputPath, 80)) {
            imagedestroy($sourceImage);
            imagedestroy($croppedImage);
            return true;
        }

        return false;
    }
}

$controller = new ImageUploadController();
$controller->upload();
