<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title><?= isset($game['pNombre']) ? htmlspecialchars($game['pNombre']) . ' ' . htmlspecialchars($game['pApellido']) : 'Jugador' ?></title>
    <link rel="stylesheet" href="../public/css/style.css">
    <link rel="stylesheet" href="../public/css/tournament.css">
    <link rel="stylesheet" href="../public/css/player.css">
</head>

<body>
    <div class="wb">
        <div class="player displayColumnCenter">
            <div class="name"><?= htmlspecialchars($player['pNombre']) ?> <?= htmlspecialchars($player['pApellido']) ?></div>
            <div class="category">Categoria <?= htmlspecialchars($player['categoria']) ?></div>
            <img src="../public/img/user/<?= !empty($player['pic']) ? 'player_' . htmlspecialchars($player['pic']) . '.webp' : 'user.png' ?>" class="pic radiusCircle">
        </div>

        <div class="tournament">
            <div class="tittle">MIS TORNEOS</div>
            <?php
            if (isset($tournaments['name'])) {
                $tournaments = [$tournaments];
            }
            if (!empty($tournaments)): ?>
                <?php foreach ($tournaments as $tournament): ?>
                    <?php if (is_array($tournament) && isset($tournament['name'])): ?>
                        <div class="tournamentCard" onclick="toggleGames('<?= htmlspecialchars($tournament['id']); ?>')">
                            <div class="tittle"><?= htmlspecialchars($tournament['name']); ?></div>
                            <div class="games" id="gamesT<?= htmlspecialchars($tournament['id']); ?>"></div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</body>

</html>
<script>
    function toggleGames(tournamentId) {
        const gamesT = document.getElementById('gamesT' + tournamentId);

        if (gamesT.innerHTML !== '') {
            gamesT.classList.toggle('visible');
        } else {
            fetch('../controllers/api/get_games.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        tournament: tournamentId,
                        player: <?= $_GET['id'] ?>
                    })
                })
                .then(response => response.json())
                .then(data => {
                    data.forEach((game) => {
                        const winner = 
                            (game.s1t1 ? game.s1t1 : 0) + 
                            (game.s2t1 ? game.s2t1 : 0) + 
                            (game.s3t1 ? game.s3t1 : 0) > 
                            (game.s1t2 ? game.s1t2 : 0) + 
                            (game.s2t2 ? game.s2t2 : 0) + 
                            (game.s3t2 ? game.s3t2 : 0);
                        
                        gamesT.innerHTML += `
                    <a href="../public/game.php?id=${game.id}&tournament=${game.tournamentId}">
                        <div class="gameCard">
                            <div class="gameCardHead displayRow">
                                <img class="padelBall" loading="lazy" src="../public/img/padelBall.webp">
                                <div class="info displayColumn">
                                    <div class="date">${game.date ? game.date : ''}</div>
                                    <div class="name">${game.desc ? game.desc : ''}</div>
                                </div>
                            </div>
                            <div class="gameCardBody displayRowSpaceBetween">
                                <div class="players displayColumn">
                                    ${[1, 2].map(i => `
                                        <div class="team displayRow">
                                            <div class="pics displayRow">
                                                <img class="pic radiusCircle ${i === 1 ? (winner ? 'winner' : '') : (winner ? '' : 'winner')}"
                                                    src="../public/img/user/${game['p' + (i * 2 - 1) + '_pic'] ? 'player_' + game['p' + (i * 2 - 1) + '_pic'] + '.webp' : 'user.png'}" loading="lazy">
                                                <img class="pic radiusCircle ${i === 1 ? (winner ? 'winner' : '') : (winner ? '' : 'winner')}"
                                                    src="../public/img/user/${game['p' + (i * 2) + '_pic'] ? 'player_' + game['p' + (i * 2) + '_pic'] + '.webp' : 'user.png'}" loading="lazy">
                                            </div>
                                            <div class="names displayColumn">
                                                <div class="name ${i === 1 ? (winner ? 'winner' : '') : (winner ? '' : 'winner')}">
                                                    ${game['p' + (i * 2 - 1) + '_pNombre'] ? game['p' + (i * 2 - 1) + '_pNombre'] : ''} ${game['p' + (i * 2 - 1) + '_pApellido'] ? game['p' + (i * 2 - 1) + '_pApellido'] : ''}
                                                </div>
                                                <div class="name ${i === 1 ? (winner ? 'winner' : '') : (winner ? '' : 'winner')}">
                                                    ${game['p' + (i * 2) + '_pNombre'] ? game['p' + (i * 2) + '_pNombre'] : ''} ${game['p' + (i * 2) + '_pApellido'] ? game['p' + (i * 2) + '_pApellido'] : ''}
                                                </div>
                                            </div>
                                        </div>
                                    `).join('')}
                                </div>
                                <div class="sets displayColumn">
                                    <div class="set ${winner ? 'winner' : ''}">
                                        ${game.s1t1 ? game.s1t1 : ''} ${game.s2t1 ? game.s2t1 : ''} ${game.s3t1 ? game.s3t1 : ''}
                                    </div>
                                    <div class="set ${winner ? '' : 'winner'}">
                                        ${game.s1t2 ? game.s1t2 : ''} ${game.s2t2 ? game.s2t2 : ''} ${game.s3t2 ? game.s3t2 : ''}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>`;
                    });
                    gamesT.classList.add('visible');
                })
                .catch(error => console.error('Error:', error));
        }
    }
</script>