<?php require '../utils/helpers.php' ?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars(($entity['name'] ?? 'Lista de Torneos')) ?></title>
    <link rel="stylesheet" href="../public/css/style.css">
    <link rel="stylesheet" href="../public/css/manager.css">
    <meta property="og:title" content="<?= htmlspecialchars(($entity['name'] ?? 'Lista de Torneos')) ?>">
    <meta property="og:description" content="Explora nuestros torneos organizados por <?= htmlspecialchars(($entity['name'] ?? '')) ?>.">
    <meta property="og:image" content="https://padelbull.cl/app/public/img/entity/<?= htmlspecialchars($entity['pic'] ?? 'default') ?>.webp">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://padelbull.cl/app/public/manager.php">
</head>

<body>
    <div class="wb">
        <div class="head displayRowSpaceBetween">
            <div class="displayRow">
                <?php if (!empty($entity['pic'])): ?>
                    <img class="icon" src="../public/img/entity/<?= htmlspecialchars($entity['pic']) ?>.webp" alt="<?= htmlspecialchars($entity['name']) ?>" loading="lazy">
                <?php endif; ?>
                <div>
                    <div class="tittle"><?= htmlspecialchars(($entity['name']) ?? '') ?></div>
                    <div class="subTittle">Organizador de torneos</div>
                </div>
            </div>
        </div>
        <div class="tournamentTittle">Nuestros Torneos</div>
        <div class="carousel">
            <div class="track">
                <?php foreach ($tournaments as $tournament) : ?>
                    <div class="card displayColumnCenter" id="tournament<?= htmlspecialchars($tournament['id']); ?>">
                        <a class="displayColumnCenter" href="../public/tournament.php?id=<?= htmlspecialchars($tournament['id']); ?>">
                            <img class="pic" loading="lazy" src="../public/img/tournament/banner-<?= htmlspecialchars($tournament['pic'] ?? 'default') ?>.webp"></img>
                        </a>
                        <div class="tittle"><?= htmlspecialchars($tournament['name']); ?></div>
                        <div class="date"><?= formatDateAbbreviated(htmlspecialchars($tournament['date'])); ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</body>
</html>
