<?php
function formatDateAbbreviated($dateString)
{
    $date = new DateTime($dateString);
    $diasSemana = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];
    $meses = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];
    $diaSemana = $diasSemana[$date->format('w')];
    $diaMes = $date->format('j');
    $mes = $meses[$date->format('n') - 1];

    if ($date->format('H:i') == '00:00') {
        return "$diaSemana $diaMes de $mes";
    } else {
        $hora = $date->format('H:i');
        return "$diaSemana $diaMes de $mes, $hora";
    }
}
