<?php
class Club
{
    private $db;

    public function __construct($database)
    {
        $this->db = $database;
    }

    public function getClubs()
    {
        $query = "SELECT id, code, name FROM club";
        return $this->db->query($query)->fetch_all(MYSQLI_ASSOC);
    }

    public function getClubByCode($code)
    {
        $query = "SELECT * FROM club WHERE code = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param('s', $code);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc() ?? null;
    }

    public function getClubCodeById($id)
    {
        $query = "SELECT code FROM club WHERE id = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc()['code'] ?? null;
    }

    public function getClubIdByCode($code)
    {
        $query = "SELECT id FROM club WHERE code = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param('s', $code);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc()['id'] ?? null;
    }
}
