<?php
class Ad
{
    private $conn;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function getAdByTournament($tournamentId)
    {
        $tournament = new Tournament($this->conn);
        $tournamentCode = $tournament->getTournamentCodeById($tournamentId);

        if ($tournamentCode === null) {
            return [];
        }

        $sql = "SELECT ads.tournament, ads.game, ads.ad, ads.description, ads.state,
                a.name as ad_name, a.link as link,
                s.id as sponsor, s.name as sponsor_name, s.pic as sponsor_pic, s.web as sponsor_web
                FROM ads 
                INNER JOIN ad a ON ads.ad = a.code
                INNER JOIN sponsor s ON a.sponsor = s.code
                WHERE ads.tournament = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('s', $tournamentCode);
        $stmt->execute();
        return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }
}
