<?php
require_once '../../../../4p1c_4cc45t0db._.php';
require_once '../../models/Player.php';
require_once '../../models/Game.php';
require_once '../../models/Tournament.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['player'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing parameter']);
    exit;
}

$db = Database::connect();

$gameModel = new Game($db);
$games = $gameModel->getGamesByTournamentAndPlayer($data['tournament'], $data['player']);

header('Content-Type: application/json');
echo json_encode($games);
