<?php
require_once '../../../4p1c_4cc45t0db._.php';
require_once '../models/Game.php';
require_once '../models/Tournament.php';
require_once '../models/Team.php';
require_once '../models/Ad.php';
require_once '../models/Club.php';
require_once '../models/Court.php';

class GameController
{
    private $teamModel;
    private $gameModel;
    private $adModel;
    private $clubModel;
    private $courtModel;

    public function __construct()
    {
        $db = Database::connect();
        $this->teamModel = new Team($db);
        $this->gameModel = new Game($db);
        $this->adModel = new Ad($db);
        $this->clubModel = new Club($db);
        $this->courtModel = new Court($db);
    }

    public function show($id, $tournamentId)
    {
        $game = null;
        if ($id) {
            $game = $this->gameModel->getGameById($id);
            $game['t1'] = $this->teamModel->getTeamIdByCode($game['t1']);
            $game['t2'] = $this->teamModel->getTeamIdByCode($game['t2']);
            $ads = $this->adModel->getAdByTournament($tournamentId);
            $courts = isset($game['club']) ? $this->courtModel->getCourtsByClub($game['club']) : [];
            $game['club'] = $this->clubModel->getClubIdByCode($game['club']);
            $game['court'] = $this->courtModel->getCourtIdByCode($game['court']);
        }

        $teams = $this->teamModel->getTeamsByTournament($tournamentId);
        $clubs = $this->clubModel->getClubs();

        require '../views/game.php';
    }
}
